<?php
require 'vendor/autoload.php';

use Smalot\PdfParser\Parser;

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['boletin'])) {
    $uploadDir = __DIR__ . '/';
    $uploadFile = $uploadDir . 'boletin.pdf';

    // Mover el archivo subido a la ubicación deseada y renombrarlo
    if (move_uploaded_file($_FILES['boletin']['tmp_name'], $uploadFile)) {
        echo "El archivo fue subido exitosamente. Se encontro:<hr>";

        // Crear una instancia del parser de PDF
        $parser = new Parser();
        $pdf = $parser->parseFile($uploadFile);

        // Obtener el texto del PDF
        $text = $pdf->getText();
        //echo $text;
        
        // Buscar todas las ocurrencias de "DIVIDENDO EN EFECTIVO"
        $dividendos = [];
        $offset = 0;

        while (($pos = strpos($text, 'DIVIDENDO EN EFECTIVO', $offset)) !== false) {
            // Encontrar la posición de "EMISORA" más cercana hacia atrás
            $emisora_pos = strrpos(substr($text, 0, $pos), 'EMISORA');
            // Encontrar la posición de "NOTAS" después de "DIVIDENDO EN EFECTIVO"
            $notas_pos = strpos($text, 'NOTAS', $pos);
            // Encontrar la posición del siguiente "EMISORA" después de "DIVIDENDO EN EFECTIVO"
            $next_emisora_pos = strpos($text, 'EMISORA', $pos + strlen('DIVIDENDO EN EFECTIVO'));

            if ($emisora_pos !== false) {
                // Determinar la posición final de la sección
                if ($notas_pos !== false && ($next_emisora_pos === false || $notas_pos < $next_emisora_pos)) {
                    $end_pos = $notas_pos + 5; // +5 para incluir 'NOTAS'
                } elseif ($next_emisora_pos !== false) {
                    $end_pos = $next_emisora_pos;
                } else {
                    $end_pos = strlen($text); // En caso de no encontrar "NOTAS" ni "EMISORA"
                }

                // Limitar la longitud de la sección a 500 caracteres después de "DIVIDENDO EN EFECTIVO"
                if ($end_pos > $pos + 500) {
                    $end_pos = $pos + 500;
                }

                // Extraer la sección desde "EMISORA" hasta la posición final determinada
                $section = substr($text, $emisora_pos, $end_pos - $emisora_pos);
                $dividendos[] = $section;
            }

            // Mover el offset para encontrar la siguiente ocurrencia
            $offset = $pos + strlen('DIVIDENDO EN EFECTIVO');
        }

        // Mostrar las secciones relevantes
        foreach ($dividendos as $index => $section) {
            echo "<pre>$section</pre>";
            echo "<hr>";
        }
    } else {
        echo "Error al subir el archivo.\n";
    }
} else {
    // Mostrar el formulario de carga de archivos
    echo '<form action="" method="post" enctype="multipart/form-data">';
    echo '    Seleccione el boletín PDF para subir:';
    echo '    <input type="file" name="boletin" accept="application/pdf">';
    echo '    <input type="submit" value="Subir Archivo">';
    echo '</form>';
}
?>